/*
 * Decompiled with CFR 0.152.
 */
package me.srrapero720.waterframes.common.screens.widgets;

import java.util.List;
import me.srrapero720.waterframes.DisplaysConfig;
import me.srrapero720.waterframes.WaterFrames;
import me.srrapero720.waterframes.common.block.entity.DisplayTile;
import me.srrapero720.waterframes.common.screens.styles.ScreenStyles;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.controls.simple.GuiTextfield;
import team.creative.creativecore.common.gui.style.GuiStyle;
import team.creative.creativecore.common.gui.style.display.StyleDisplay;
import team.creative.creativecore.common.util.text.TextBuilder;

public class WidgetURLTextField
extends GuiTextfield {
    public WidgetURLTextField(DisplayTile tile) {
        super("url");
        this.setMaxStringLength(2048);
        this.setSuggestion("https://i.imgur.com/1yCDs5C.mp4");
        this.setText(tile.data.hasUri() ? tile.data.uri.toString() : "");
    }

    public StyleDisplay getBorder(GuiStyle style, StyleDisplay display) {
        return WidgetURLTextField.isUrlValid(this.getText()) ? ScreenStyles.BLUE_BORDER : ScreenStyles.RED_BORDER;
    }

    public StyleDisplay getBackground(GuiStyle style, StyleDisplay display) {
        return ScreenStyles.DARK_BLUE_BACKGROUND;
    }

    public List<class_2561> getTooltip() {
        TextBuilder builder = new TextBuilder();
        if (this.getText().isEmpty()) {
            builder.text(String.valueOf(class_124.field_1078) + GuiControl.translate((String)"waterframes.gui.url.tooltip.empty"));
        } else if (!WidgetURLTextField.isUrlValid(this.getText())) {
            builder.text(String.valueOf(class_124.field_1061) + GuiControl.translate((String)"waterframes.gui.url.tooltip.invalid_url"));
        } else if (!DisplaysConfig.canSave(this.getPlayer(), this.getText())) {
            builder.text(String.valueOf(class_124.field_1061) + GuiControl.translate((String)"waterframes.gui.url.tooltip.not_whitelisted"));
        }
        List result = builder.build();
        return result.isEmpty() ? null : result;
    }

    public static boolean isUrlValid(String url) {
        return WaterFrames.createURI(url) != null;
    }
}

